<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* sms/index.html.twig */
class __TwigTemplate_ae0bb4ae8ade6f84b65cc7a72a572e76 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'main' => [$this, 'block_main'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "dashboard/base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "sms/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "sms/index.html.twig"));

        $this->parent = $this->load("dashboard/base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_main(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "main"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "main"));

        // line 4
        yield "    <div class=\"space-y-8 animate-in fade-in slide-in-from-bottom-4 duration-700\">
        <div class=\"flex flex-col lg:flex-row lg:items-center justify-between gap-6\">
            <div>
                <h1 class=\"text-3xl font-bold text-white tracking-tight\">Sms Logs</h1>
                <p class=\"text-slate-400 mt-1 text-sm\">Sms and filter outbound message history</p>
            </div>
            <button id=\"exportCsv\" class=\"flex items-center gap-2 px-6 py-3 bg-emerald-500 hover:bg-emerald-600 text-white rounded-xl font-bold transition-all shadow-lg shadow-emerald-500/20 text-sm\">
                <svg xmlns=\"http://www.w3.org/2000/svg\" class=\"w-4 h-4\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\">
                    <path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4\" />
                </svg>
                Download CSV Report
            </button>
        </div>

        <div class=\"grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 bg-white/5 p-6 rounded-[2rem] border border-white/10 backdrop-blur-md\">
            
            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Recipient</label>
                <input type=\"text\" id=\"serverSearch\" placeholder=\"Search client or pet...\" 
                    class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all\">
            </div>

            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Delivery Status</label>
                <select id=\"statusFilter\" class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all appearance-none\">
                    <option value=\"\">All Statuses</option>
                    <option value=\"delivered\">Successfully Delivered</option>
                    <option value=\"";
        // line 31
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::upper($this->env->getCharset(), "Queued"), "html", null, true);
        yield "\">Pending Queue</option>
                    <option value=\"failed\">Delivery Failures</option>
                </select>
            </div>

            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Date </label>
                <input type=\"date\" id=\"dateFilter\" 
                    class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all [color-scheme:dark]\">
            </div>
        </div>

        <div class=\"relative overflow-hidden bg-slate-900/40 backdrop-blur-xl border border-white/5 rounded-3xl shadow-2xl\">
            <div class=\"overflow-x-auto\">
                <table class=\"w-full text-left border-collapse\">
                    <thead>
                        <tr class=\"border-b border-white/5 bg-white/[0.02]\">
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Clinic</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Client</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Message</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Date Return</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Sender No.</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Status</th>
                        </tr>
                    </thead>
                    <tbody id=\"tableBody\" class=\"divide-y divide-white/[0.05]\">
                        </tbody>
                </table>
            </div>

            <div class=\"px-6 py-4 bg-white/[0.02] border-t border-white/5 flex items-center justify-between\">
                <button id=\"prevPage\" class=\"px-4 py-2 rounded-xl border border-white/10 text-slate-400 hover:bg-white/5 hover:text-white transition-all text-sm disabled:opacity-30 disabled:cursor-not-allowed\">
                    Previous
                </button>
                <span id=\"pageInfo\" class=\"text-xs font-mono text-slate-500 uppercase tracking-widest\">Page 1 of 1</span>
                <button id=\"nextPage\" class=\"px-4 py-2 rounded-xl border border-white/10 text-slate-400 hover:bg-white/5 hover:text-white transition-all text-sm disabled:opacity-30 disabled:cursor-not-allowed\">
                    Next
                </button>
            </div>
        </div>
    </div>

  <script>
    let currentPage = 1;
    let searchTimeout;

    async function loadSms(page = 1) {
        const tbody = document.getElementById('tableBody');
        const query = document.getElementById('serverSearch').value;
        const status = document.getElementById('statusFilter').value;
        const date = document.getElementById('dateFilter').value;
        
        tbody.style.opacity = '0.5';

        try {
            const url = `";
        // line 86
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("sms_ajax_list");
        yield "?page=\${page}&q=\${query}&status=\${status}&date=\${date}`;
            const response = await fetch(url);
            const result = await response.json();
            
            tbody.innerHTML = result.data.map(server => {
                const fullMessage = server.message || '';
                const isLong = fullMessage.length > 120;
                const shortMessage = isLong ? fullMessage.substring(0, 120) + '...' : fullMessage;

                return `
                <tr class=\"group hover:bg-white/[0.02] transition-colors\">
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.companyName}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.clientName} (\${server.clientNo})</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono cursor-help\" title=\"\${fullMessage.replace(/\"/g, '&quot;')}\">
                        <div class=\"max-w-xs xl:max-w-md\">\${shortMessage}</div>
                    </td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.dateReturn}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.senderNo}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">
                        <span class=\"px-2 py-1 rounded text-xs \${
                            server.status === 'QUEUED' || server.status === 'PENDING' 
                            ? 'bg-blue-500/10 text-blue-400' 
                            : server.status === 'FAILED' 
                            ? 'bg-red-500/10 text-red-400' 
                            : 'bg-green-500/10 text-green-400'
                        }\">
                            \${server.status}
                        </span>
                    </td>
                </tr>
                `;
            }).join('');

            document.getElementById('pageInfo').innerText = `Page \${result.page} of \${result.last_page}`;
            document.getElementById('prevPage').disabled = (result.page <= 1);
            document.getElementById('nextPage').disabled = (result.page >= result.last_page);
            currentPage = result.page;
        } finally {
            tbody.style.opacity = '1';
        }
    }

    document.getElementById('serverSearch').addEventListener('input', () => {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => loadSms(1), 400);
    });

    document.getElementById('statusFilter').addEventListener('change', () => loadSms(1));
    document.getElementById('dateFilter').addEventListener('change', () => loadSms(1));

    document.getElementById('prevPage').onclick = () => loadSms(currentPage - 1);
    document.getElementById('nextPage').onclick = () => loadSms(currentPage + 1);

    document.getElementById('exportCsv').addEventListener('click', () => {
        const query = document.getElementById('serverSearch').value;
        const status = document.getElementById('statusFilter').value;
        const date = document.getElementById('dateFilter').value;
        
        const url = `";
        // line 144
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("sms_export_csv");
        yield "?q=\${query}&status=\${status}&date=\${date}`;
        
        window.location.href = url;
    });

    loadSms();
</script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "sms/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  224 => 144,  163 => 86,  105 => 31,  76 => 4,  63 => 3,  40 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'dashboard/base.html.twig' %}

{% block main %}
    <div class=\"space-y-8 animate-in fade-in slide-in-from-bottom-4 duration-700\">
        <div class=\"flex flex-col lg:flex-row lg:items-center justify-between gap-6\">
            <div>
                <h1 class=\"text-3xl font-bold text-white tracking-tight\">Sms Logs</h1>
                <p class=\"text-slate-400 mt-1 text-sm\">Sms and filter outbound message history</p>
            </div>
            <button id=\"exportCsv\" class=\"flex items-center gap-2 px-6 py-3 bg-emerald-500 hover:bg-emerald-600 text-white rounded-xl font-bold transition-all shadow-lg shadow-emerald-500/20 text-sm\">
                <svg xmlns=\"http://www.w3.org/2000/svg\" class=\"w-4 h-4\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\">
                    <path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4\" />
                </svg>
                Download CSV Report
            </button>
        </div>

        <div class=\"grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 bg-white/5 p-6 rounded-[2rem] border border-white/10 backdrop-blur-md\">
            
            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Recipient</label>
                <input type=\"text\" id=\"serverSearch\" placeholder=\"Search client or pet...\" 
                    class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all\">
            </div>

            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Delivery Status</label>
                <select id=\"statusFilter\" class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all appearance-none\">
                    <option value=\"\">All Statuses</option>
                    <option value=\"delivered\">Successfully Delivered</option>
                    <option value=\"{{'Queued'|upper}}\">Pending Queue</option>
                    <option value=\"failed\">Delivery Failures</option>
                </select>
            </div>

            <div class=\"flex flex-col gap-2\">
                <label class=\"text-xs font-bold text-emerald-400 uppercase tracking-widest ml-1\">Date </label>
                <input type=\"date\" id=\"dateFilter\" 
                    class=\"bg-slate-900/50 border border-white/10 text-white text-sm rounded-xl px-4 py-3 focus:outline-none focus:ring-2 focus:ring-emerald-500/50 transition-all [color-scheme:dark]\">
            </div>
        </div>

        <div class=\"relative overflow-hidden bg-slate-900/40 backdrop-blur-xl border border-white/5 rounded-3xl shadow-2xl\">
            <div class=\"overflow-x-auto\">
                <table class=\"w-full text-left border-collapse\">
                    <thead>
                        <tr class=\"border-b border-white/5 bg-white/[0.02]\">
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Clinic</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Client</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Message</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Date Return</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Sender No.</th>
                            <th class=\"px-6 py-4 text-xs uppercase tracking-widest text-emerald-400 font-bold\">Status</th>
                        </tr>
                    </thead>
                    <tbody id=\"tableBody\" class=\"divide-y divide-white/[0.05]\">
                        </tbody>
                </table>
            </div>

            <div class=\"px-6 py-4 bg-white/[0.02] border-t border-white/5 flex items-center justify-between\">
                <button id=\"prevPage\" class=\"px-4 py-2 rounded-xl border border-white/10 text-slate-400 hover:bg-white/5 hover:text-white transition-all text-sm disabled:opacity-30 disabled:cursor-not-allowed\">
                    Previous
                </button>
                <span id=\"pageInfo\" class=\"text-xs font-mono text-slate-500 uppercase tracking-widest\">Page 1 of 1</span>
                <button id=\"nextPage\" class=\"px-4 py-2 rounded-xl border border-white/10 text-slate-400 hover:bg-white/5 hover:text-white transition-all text-sm disabled:opacity-30 disabled:cursor-not-allowed\">
                    Next
                </button>
            </div>
        </div>
    </div>

  <script>
    let currentPage = 1;
    let searchTimeout;

    async function loadSms(page = 1) {
        const tbody = document.getElementById('tableBody');
        const query = document.getElementById('serverSearch').value;
        const status = document.getElementById('statusFilter').value;
        const date = document.getElementById('dateFilter').value;
        
        tbody.style.opacity = '0.5';

        try {
            const url = `{{ path('sms_ajax_list') }}?page=\${page}&q=\${query}&status=\${status}&date=\${date}`;
            const response = await fetch(url);
            const result = await response.json();
            
            tbody.innerHTML = result.data.map(server => {
                const fullMessage = server.message || '';
                const isLong = fullMessage.length > 120;
                const shortMessage = isLong ? fullMessage.substring(0, 120) + '...' : fullMessage;

                return `
                <tr class=\"group hover:bg-white/[0.02] transition-colors\">
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.companyName}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.clientName} (\${server.clientNo})</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono cursor-help\" title=\"\${fullMessage.replace(/\"/g, '&quot;')}\">
                        <div class=\"max-w-xs xl:max-w-md\">\${shortMessage}</div>
                    </td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.dateReturn}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">\${server.senderNo}</td>
                    <td class=\"px-6 py-5 text-slate-400 text-sm font-mono\">
                        <span class=\"px-2 py-1 rounded text-xs \${
                            server.status === 'QUEUED' || server.status === 'PENDING' 
                            ? 'bg-blue-500/10 text-blue-400' 
                            : server.status === 'FAILED' 
                            ? 'bg-red-500/10 text-red-400' 
                            : 'bg-green-500/10 text-green-400'
                        }\">
                            \${server.status}
                        </span>
                    </td>
                </tr>
                `;
            }).join('');

            document.getElementById('pageInfo').innerText = `Page \${result.page} of \${result.last_page}`;
            document.getElementById('prevPage').disabled = (result.page <= 1);
            document.getElementById('nextPage').disabled = (result.page >= result.last_page);
            currentPage = result.page;
        } finally {
            tbody.style.opacity = '1';
        }
    }

    document.getElementById('serverSearch').addEventListener('input', () => {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => loadSms(1), 400);
    });

    document.getElementById('statusFilter').addEventListener('change', () => loadSms(1));
    document.getElementById('dateFilter').addEventListener('change', () => loadSms(1));

    document.getElementById('prevPage').onclick = () => loadSms(currentPage - 1);
    document.getElementById('nextPage').onclick = () => loadSms(currentPage + 1);

    document.getElementById('exportCsv').addEventListener('click', () => {
        const query = document.getElementById('serverSearch').value;
        const status = document.getElementById('statusFilter').value;
        const date = document.getElementById('dateFilter').value;
        
        const url = `{{ path('sms_export_csv') }}?q=\${query}&status=\${status}&date=\${date}`;
        
        window.location.href = url;
    });

    loadSms();
</script>
{% endblock %}", "sms/index.html.twig", "D:\\nextg\\textblast\\textblast\\templates\\sms\\index.html.twig");
    }
}
