<?php

namespace App\Repository;

use App\Entity\SmsEntity;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<SmsEntity>
 */
class SmsRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, SmsEntity::class);
    }

    //    /**
    //     * @return SmsEntity[] Returns an array of SmsEntity objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('s')
    //            ->andWhere('s.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('s.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?SmsEntity
    //    {
    //        return $this->createQueryBuilder('s')
    //            ->andWhere('s.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }

    public function findForExport($query = null, $status = null, $date = null)
    {
        $qb = $this->createQueryBuilder('s');

        if ($query) {
            $qb->andWhere('s.clientName LIKE :q OR s.companyName LIKE :q')
            ->setParameter('q', '%'.$query.'%');
        }

        if ($status) {
            $qb->andWhere('s.status = :status')
            ->setParameter('status', $status);
        }

        if ($date) {
            $qb->andWhere('s.dateReturn LIKE :date')
            ->setParameter('date', $date.'%');
        }

        return $qb->orderBy('s.id', 'DESC')->getQuery()->getResult();
    }
}
