<?php

namespace App\Form;

use App\Entity\ServerEntity;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType as AppCheckbox;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;

class ServerForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('code', TextType::class, [
                'label' => 'Code',
            ])
            ->add('description', TextType::class, [
                'label' => 'Description',
            ])
            ->add('isActive', AppCheckbox::class, [
                'label'    => 'Status',
                'required' => false,
                'data'     => true,
                'attr'     => [
                    'class' => 'status-toggle', 
                ],
                'help'     => 'Toggle to activate or deactivate this server.',
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => ServerEntity::class,
            'is_new' => true, 
        ]);

        $resolver->setAllowedTypes('is_new', 'bool');
    }
}