<?php 

namespace App\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use App\Entity\ServerEntity;

#[ORM\Entity(repositoryClass: \App\Repository\SmsRepository::class)]
#[ORM\Table(name: 'sms')]
class SmsEntity
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $message = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $clientNo = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $companyName = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $clientName = null;

    #[ORM\Column(type: 'datetime')]
    private ?\DateTimeInterface $scheduleDateCreated = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $comment = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $itemName = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $dateReturn = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $uniqueId = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $code = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $senderNo = null;

    #[ORM\Column(length: 20)]
    private ?string $status = 'QUEUED'; 

    #[ORM\Column]
    private ?int $sendingAttempt = 0; 

    #[ORM\Column(type: 'datetime_immutable', nullable: true)]
    private ?\DateTimeImmutable $updatedAt = null;

    #[ORM\ManyToOne(targetEntity: ServerEntity::class, inversedBy: 'smss', cascade: ['persist'])]
    #[ORM\JoinColumn(nullable: false)]
    private ?ServerEntity $server = null;

    #[ORM\PreUpdate]
    public function setUpdatedAt(): void
    {
        $this->updatedAt = new \DateTimeImmutable();
    }



    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): static
    {
        $this->message = $message;

        return $this;
    }

    public function getClientNo(): ?string
    {
        return $this->clientNo;
    }

    public function setClientNo(?string $clientNo): static
    {
        $this->clientNo = $clientNo;

        return $this;
    }

    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    public function setCompanyName(?string $companyName): static
    {
        $this->companyName = $companyName;

        return $this;
    }

    public function getClientName(): ?string
    {
        return $this->clientName;
    }

    public function setClientName(?string $clientName): static
    {
        $this->clientName = $clientName;

        return $this;
    }

    public function getScheduleDateCreated(): ?\DateTimeInterface 
    {
        return $this->scheduleDateCreated;
    }

    public function setScheduleDateCreated(\DateTimeInterface $scheduleDateCreated): static 
    {
        $this->scheduleDateCreated = $scheduleDateCreated;

        return $this;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function setComment(?string $comment): static
    {
        $this->comment = $comment;

        return $this;
    }

    public function getItemName(): ?string
    {
        return $this->itemName;
    }

    public function setItemName(?string $itemName): static
    {
        $this->itemName = $itemName;

        return $this;
    }

    public function getDateReturn(): ?string
    {
        return $this->dateReturn;
    }

    public function setDateReturn(?string $dateReturn): static
    {
        $this->dateReturn = $dateReturn;

        return $this;
    }

    public function getUniqueId(): ?string
    {
        return $this->uniqueId;
    }

    public function setUniqueId(?string $uniqueId): static
    {
        $this->uniqueId = $uniqueId;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function getSenderNo(): ?string
    {
        return $this->senderNo;
    }

    public function setSenderNo(?string $senderNo): static
    {
        $this->senderNo = $senderNo;

        return $this;
    }

    public function getServer(): ?ServerEntity
    {
        return $this->server;
    }

    public function setServer(?ServerEntity $server): static
    {
        $this->server = $server;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): static
    {
        $this->status = $status;

        return $this;
    }

    public function getSendingAttempt(): ?int
    {
        return $this->sendingAttempt;
    }

    public function setSendingAttempt(int $sendingAttempt): static
    {
        $this->sendingAttempt = $sendingAttempt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->updatedAt;
    }
   
}

?>