<?php 
namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

#[Route(path: '/dashboard')]
class DashboardController extends AbstractController
{
    #[Route(path: '/', name: 'dashboard_index', methods: ['GET'])]
    public function index(Request $request): Response 
    {
        if (!$request->getSession()->has('user')) { 
             $this->addFlash('error', 'Authentication required. Please log in.');
            return $this->redirectToRoute('auth_login');
        }

        return $this->render('dashboard/index.html.twig', [
            'user' => $request->getSession()->get('user_auth')
        ]);
    }
}
?>