<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use App\Repository\UserRepository;
use App\Form\LoginForm;

#[Route(path: '/auth')]
class AuthController extends AbstractController
{
   #[Route(path: '/login', name: 'auth_login', methods: ['GET', 'POST'])]
    public function login(
        Request $request, 
        UserRepository $userRepository, 
        UserPasswordHasherInterface $passwordHasher
    ): Response {
        
    $form = $this->createForm(LoginForm::class);
    $form->handleRequest($request);

    if ($form->isSubmitted() && $form->isValid()) {
        $data = $form->getData();
        $user = $userRepository->findOneBy(['email' => $data['email'], 'isDeleted' => false]);

        if ($user && $passwordHasher->isPasswordValid($user, $data['password'])) {
            $request->getSession()->set('user', [
                'id' => $user->getId(),
                'email' => $user->getEmail(),
                'fullName' => $user->getFullName(),
                'type' => $user->getType()
            ]);
            
            $lifetime = $data['remember_me'] ? 2592000 : 0;
            $request->getSession()->migrate(true, $lifetime);

            $this->addFlash('success', 'Welcome back!');
            return $this->redirectToRoute('dashboard_index');
        }

        $this->addFlash('error', 'Invalid users or wrong password.');
    }

        return $this->render('auth/login.html.twig', [
            'loginForm' => $form->createView(),
        ]);
    }

   #[Route(path: '/logout', name: 'auth_logout')]
    public function logout(Request $request): Response
    {
        $session = $request->getSession();
        $session->remove('user');
        $session->invalidate();
        $this->addFlash('success', 'You have been logged out successfully.');

        return $this->redirectToRoute('auth_login');
    }
}
