<?php

namespace App\Command;

use App\Entity\SmsEntity;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
    name: 'app:sms-reset-stuck',
    description: 'Resets SMS records stuck in SENDING status for more than 30 minutes back to QUEUED'
)]
class SmsResetStuckCommand extends Command
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        
        $threshold = new \DateTimeImmutable('-30 minutes');

        $io->note(sprintf('Searching for stuck SMS records updated before %s', $threshold->format('Y-m-d H:i:s')));
        $stuckSmsRecords = $this->entityManager->getRepository(SmsEntity::class)
            ->createQueryBuilder('s')
            ->where('s.status = :status')
            ->andWhere('s.updatedAt < :threshold')
            ->setParameter('status', 'SENDING') 
            ->setParameter('threshold', $threshold)
            ->getQuery()
            ->getResult();

        if (!$stuckSmsRecords) {
            $io->success('No stuck records found.');
            return Command::SUCCESS;
        }

        $count = 0;
        foreach ($stuckSmsRecords as $sms) {
            $sms->setStatus('QUEUED');
            $count++;
        }

        $this->entityManager->flush();

        $io->success(sprintf('Reset %d records back to QUEUED status.', $count));

        return Command::SUCCESS;
    }
}